dofile(LockOn_Options.common_script_path..'Radio.lua')
dofile(LockOn_Options.common_script_path.."mission_prepare.lua")

local gettext = require("i_18n")
_ = gettext.translate

frequency_dial = {limit = {100E6,399999E3}, dials = {{157,100.0,1E7, shift= 10, limit = {10,40}},{158,10.0,1E6},{159,10.0,1E5},{160,100.0,1E3,limit = {0,100}}}}

innerNoise			= getInnerNoise(2.5E-6, 6)
frequency_accuracy 	= 1000.0		--Hz
band_width			= 25E3			--Hz 

power_MW			= 10.0			-- Power in metric range, Watts
power_DMW			= 8.0			-- Power in decimetric range, Watts

agr = {
	input_signal_deviation		= 50.0, --Db
	output_signal_deviation		= 5.0,  --Db
	input_signal_linear_zone 	= 10.0,  --Db
	regulation_time				= 0.25, --sec
}

--added by HF for adjustable radio in ME (code by Imp based on LNS MiG-21)
presets = {}
-- fixed default presets added by HF; frequency in Hz
presets[1] = 124000000.0	--Krymsk/FC3/AWACS (AM)
presets[2] = 121000000.0	--Anapa (AM)
presets[3] = 131000000.0	--Batumi (AM)
presets[4] = 141000000.0	--Beslan (AM)
presets[5] = 126000000.0	--Gelendzhik (AM)
presets[6] = 130000000.0	--Gudauta (AM)
presets[7] = 133000000.0	--Kobuleti (AM)
presets[8] = 122000000.0	--Krasnodar Centre (AM)
presets[9] = 128000000.0	--Krasnodar Pash (AM)
presets[10] = 134000000.0	--Kutasai (AM)
presets[11] = 125000000.0	--Maykop (AM)
presets[12] = 135000000.0	--Mineralnye Vody (AM)
presets[13] = 137000000.0	--Mozdok (AM)
presets[14] = 136000000.0	--Nalchik (AM)
presets[15] = 123000000.0	--Novorossiysk (AM)
presets[16] = 132000000.0	--Senaki (AM)
presets[19] = 127000000.0	--Sochi Adler (AM)
presets[18] = 129000000.0	--Sukhumi (AM)
--presets[19] = 139000000.0	--Tblisi Soganlug (AM)
presets[19] = 138000000.0	--Tblisi Lochini (AM)
presets[20] = 14000000.0	--Vazani (AM)
--end default frequencies by HF

if get_aircraft_mission_data ~= nil then
    local  radio_from_mission = get_aircraft_mission_data("Radio")
    local  radio_1 = radio_from_mission[1]
    if radio_1 then
        for i = 1,20 do
            presets[i] = (radio_1.channels[i] or 131 ) * 1e6
        end
    end
end
--end adds by HF

GUI = {
	ranges = { 	{min = 100E6, max = 149975E3, step = 25E3}, --Hz
				{min = 220E6, max = 399975E3, step = 25E3} },
	displayName = _('R-863'),
	AM = true,
	FM = true,
	channels = presets,		--added by HF for adjustable radio in ME (code by Imp based on LNS MiG-21) 
}
